(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5619,        135]*)
(*NotebookOutlinePosition[      6262,        157]*)
(*  CellTagsIndexPosition[      6218,        153]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(puntos = {{{\(-3\), 0}, {\(-3\),  .25}}, {{\(-2\), 
            0}, {\(-2\),  .75}}, {{\(-1\), 0}, {\(-1\), 1. }}, {{0, 
            0}, {0,  .25}}, {{3, 0}, {3,  .25}}, {{2, 0}, {2,  .75}}, {{1, 
            0}, {1, 1. }}, {{4, 0}, {4,  .15}}}\)], "Input"],

Cell[BoxData[
    \(valores = {{\(-3\),  .25}, {\(-2\),  .75}, {\(-1\), 
          1.0}, {0,  .25}, {3,  .25}, {2,  .75}, {1, 
          1.0}, {4,  .15}}\)], "Input"],

Cell[BoxData[
    \(Point /@ valores\)], "Input"],

Cell[BoxData[
    \(Line /@ puntos\)], "Input"],

Cell[BoxData[
    \(\(texto = {Text[\*"\"\<|\!\(c\_\(-3\)\)|\>\"", {\(-3\), 
              0.32}, {0, \(-1\)}], 
          Text[\*"\"\<|\!\(c\_\(-2\)\)|\>\"", {\(-2\), 0.82}, {0, \(-1\)}], 
          Text[\*"\"\<|\!\(c\_\(-1\)\)|\>\"", {\(-1\), 1.07}, {0, \(-1\)}], 
          Text[\*"\"\<|\!\(c\_0\)|\>\"", {0.3, 0.4}, {0, 1}], 
          Text[\*"\"\<|\!\(c\_1\)|\>\"", {3, 0.32}, {0, \(-1\)}], 
          Text[\*"\"\<|\!\(c\_2\)|\>\"", {2, 0.82}, {0, \(-1\)}], 
          Text[\*"\"\<|\!\(c\_3\)|\>\"", {1, 1.07}, {0, \(-1\)}], 
          Text[\*"\"\<|\!\(c\_4\)|\>\"", {4,  .22}, {0, \(-1\)}], 
          Text["\<-3/T\>", {\(-3.1\), \(- .22\)}], 
          Text["\<-2/T\>", {\(-2.1\), \(- .22\)}], 
          Text["\<-1/T\>", {\(-1.1\), \(- .22\)}], 
          Text["\<0\>", {0.15, \(- .22\)}], Text["\<1/T\>", {1, \(- .22\)}], 
          Text["\<2/T\>", {2, \(- .22\)}], Text["\<3/T\>", {3, \(- .22\)}], 
          Text["\<4/T\>", {4, \(- .22\)}]};\)\)], "Input"],

Cell[BoxData[
    \(graf1 = 
      Show[Graphics[{{Thickness[0.006], Line /@ puntos}, {PointSize[ .015], 
              Point /@ valores}, texto}], AspectRatio \[Rule] 1/3, 
        Axes \[Rule] True, PlotRange \[Rule] {\(- .4\), 1.3}, 
        AxesLabel \[Rule] None, Ticks \[Rule] None, 
        ImageSize \[Rule] {538.688, 179.563}, 
        TextStyle \[Rule] {FontFamily\  -> \ "\<Helvetica\>", 
            FontSize \[Rule] 10, FontWeight -> "\<Bold\>"}]\)], "Input"],

Cell[BoxData[
    \(Export["\<amplitudes.png\>", graf1, "\<PNG\>"]\)], "Input"],

Cell[BoxData[
    \(puntos = {{{\(-3\), 0}, {\(-3\), \(- .75\)}}, {{\(-2\), 
            0}, {\(-2\),  .25}}, {{\(-1\), 0}, {\(-1\), \(-1. \)}}, {{3, 
            0}, {3,  .75}}, {{2, 0}, {2, \(- .25\)}}, {{1, 0}, {1, 
            1. }}}\)], "Input"],

Cell[BoxData[
    \(\(texto = {Text[\*"\"\<\!\(\[Phi]\_\(-3\)\)\>\"", {\(-3\), \(-0.82\)}, \
{0, 1}], Text[\*"\"\<\!\(\[Phi]\_\(-2\)\)\>\"", {\(-2\), 0.32}, {0, \(-1\)}], 
          Text[\*"\"\<\!\(\[Phi]\_\(-1\)\)\>\"", {\(-1\), \(-1.07\)}, {0, 
              1}], Text[\*"\"\<\!\(\[Phi]\_3\)\>\"", {3, 0.82}, {0, \(-1\)}], 
          Text[\*"\"\<\!\(\[Phi]\_2\)\>\"", {2, \(-0.32\)}, {0, 1}], 
          Text[\*"\"\<\!\(\[Phi]\_1\)\>\"", {1, 1.07}, {0, \(-1\)}], 
          Text["\<-3/T\>", {\(-3\),  .2}], 
          Text["\<-2/T\>", {\(-2\), \(- .2\)}], 
          Text["\<-1/T\>", {\(-1\),  .2}], Text["\<0\>", {0.15, \(- .1\)}], 
          Text["\<1/T\>", {1, \(- .2\)}], Text["\<2/T\>", {2,  .2}], 
          Text["\<3/T\>", {3, \(- .2\)}]};\)\)], "Input"],

Cell[BoxData[
    \(\(valores = {{\(-3\), \(- .75\)}, {\(-2\),  .25}, {\(-1\), \(-1.0\)}, \
{3,  .75}, {2, \(- .25\)}, {1, 1.0}};\)\)], "Input"],

Cell[BoxData[
    \(graf2 = 
      Show[Graphics[{{Thickness[0.006], Line /@ puntos}, {Thickness[0.006], 
              Line[{{0, \(-1.3\)}, {0, 1.3}}]}, {PointSize[ .015], 
              Point /@ valores}, texto}], AspectRatio \[Rule] 1/2, 
        Axes \[Rule] True, PlotRange \[Rule] {\(-1.3\), 1.3}, 
        AxesLabel \[Rule] None, Ticks \[Rule] None, 
        ImageSize \[Rule] {538.688, 179.563}, 
        TextStyle \[Rule] {FontFamily\  -> \ "\<Helvetica\>", 
            FontSize \[Rule] 10, FontWeight -> "\<Bold\>"}]\)], "Input"],

Cell[BoxData[
    \(Export["\<fases.jpg\>", graf2, "\<JPG\>"]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 277, 4, 50, "Input"],
Cell[2034, 57, 166, 3, 30, "Input"],
Cell[2203, 62, 49, 1, 30, "Input"],
Cell[2255, 65, 47, 1, 30, "Input"],
Cell[2305, 68, 967, 15, 110, "Input"],
Cell[3275, 85, 472, 8, 70, "Input"],
Cell[3750, 95, 79, 1, 30, "Input"],
Cell[3832, 98, 250, 4, 50, "Input"],
Cell[4085, 104, 763, 11, 90, "Input"],
Cell[4851, 117, 144, 2, 30, "Input"],
Cell[4998, 121, 540, 9, 110, "Input"],
Cell[5541, 132, 74, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

